(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    118737,       2662]
NotebookOptionsPosition[    117489,       2631]
NotebookOutlinePosition[    117829,       2646]
CellTagsIndexPosition[    117786,       2643]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Figure 3a", "Subtitle",
 CellChangeTimes->{{3.8678197662850866`*^9, 3.8678197672522883`*^9}, {
   3.867822183088132*^9, 3.867822183743333*^9}, 3.8680005843408747`*^9, {
   3.8680094563744574`*^9, 3.868009456577258*^9}, {3.868069030751579*^9, 
   3.8680690396747947`*^9}, {3.924342535485137*^9, 
   3.9243425388728857`*^9}},ExpressionUUID->"4fdab687-5f4e-4b59-a56e-\
7c66aee03390"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cbw", "=", "200"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"cbCe", "=", "2"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"cbo", "=", "5"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"comax", "=", "2000"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"\[Phi]osteric", "=", 
   RowBox[{"2", 
    RowBox[{"cbo", "/", "comax"}]}]}], ";", 
  RowBox[{"rCe", "=", 
   RowBox[{"cbCe", "/", "cbw"}]}], ";", 
  RowBox[{"\[Epsilon]ro", "=", "9.4"}], ";", 
  RowBox[{"\[Epsilon]rw", "=", "78"}], ";", 
  RowBox[{"qwo", "=", 
   RowBox[{"\[Epsilon]rw", " ", 
    RowBox[{"cbw", "/", 
     RowBox[{"(", 
      RowBox[{"\[Epsilon]ro", " ", "cbo"}], ")"}]}]}]}], ";", 
  RowBox[{"F", "=", "96485"}], 
  RowBox[{"(*", 
   RowBox[{"C", "/", "mol"}], "*)"}], ";", 
  RowBox[{"R", "=", "8.3144"}], 
  RowBox[{"(*", 
   RowBox[{"J", "/", 
    RowBox[{"(", 
     RowBox[{"K", " ", "mol"}], ")"}]}], "*)"}], ";", 
  RowBox[{"T", "=", "298.15"}], 
  RowBox[{"(*", "K", "*)"}], ";", 
  RowBox[{"f", "=", 
   RowBox[{"F", "/", 
    RowBox[{"(", 
     RowBox[{"R", " ", "T"}], ")"}]}]}], ";", 
  RowBox[{"\[Epsilon]0", "=", 
   RowBox[{"8.85419", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "12"}]}]}]}], 
  RowBox[{"(*", 
   RowBox[{"C", "/", 
    RowBox[{"(", 
     RowBox[{"V", " ", "m"}], ")"}]}], "*)"}], ";", 
  RowBox[{"\[Kappa]o", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", " ", 
     RowBox[{"F", "^", "2"}], " ", 
     RowBox[{"cbo", "/", 
      RowBox[{"(", 
       RowBox[{"\[Epsilon]0", " ", "\[Epsilon]ro", " ", "R", " ", "T"}], 
       ")"}]}]}], "]"}]}], ";", 
  RowBox[{"\[Kappa]w", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"6", " ", 
     RowBox[{"F", "^", "2"}], " ", 
     RowBox[{"cbw", "/", 
      RowBox[{"(", 
       RowBox[{"\[Epsilon]0", " ", "\[Epsilon]rw", " ", "R", " ", "T"}], 
       ")"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"FindRoot", "::", "jsing"}], "]"}], ";", 
  RowBox[{"table", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[CapitalDelta]", ",", "x", ",", 
        RowBox[{"\[CapitalDelta]", "-", "x"}], ",", 
        RowBox[{
         RowBox[{"2", "/", 
          RowBox[{"(", 
           RowBox[{"\[Phi]osteric", " ", "qwo"}], ")"}]}], " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "+", 
           RowBox[{"\[Phi]osteric", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cosh", "[", "x", "]"}], "-", "1"}], ")"}]}]}], "]"}]}],
         ",", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", "rCe"}]}], ")"}], 
          RowBox[{"Exp", "[", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"2", 
          RowBox[{"Exp", "[", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "+", 
         RowBox[{"rCe", " ", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{"-", "4"}], 
            RowBox[{"(", 
             RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "-", 
         RowBox[{"3", 
          RowBox[{"(", 
           RowBox[{"1", "+", "rCe"}], ")"}]}]}]}], "}"}], "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"2", "/", 
           RowBox[{"(", 
            RowBox[{"\[Phi]osteric", " ", "qwo"}], ")"}]}], " ", 
          RowBox[{"Log", "[", 
           RowBox[{"1", "+", 
            RowBox[{"\[Phi]osteric", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"Cosh", "[", "x", "]"}], "-", "1"}], ")"}]}]}], 
           "]"}]}], "\[Equal]", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", "rCe"}]}], ")"}], 
           RowBox[{"Exp", "[", 
            RowBox[{"2", 
             RowBox[{"(", 
              RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "+", 
          RowBox[{"2", 
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "+", 
          RowBox[{"rCe", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{"-", "4"}], 
             RowBox[{"(", 
              RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], "-", 
          RowBox[{"3", 
           RowBox[{"(", 
            RowBox[{"1", "+", "rCe"}], ")"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"3", 
           RowBox[{"\[CapitalDelta]", "/", "4"}]}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]", ",", 
       RowBox[{
        RowBox[{"-", ".35"}], "f"}], ",", 
       RowBox[{".5", "f"}], ",", 
       RowBox[{".005", "f"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"tBA", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", 
       RowBox[{"0.001", "cbo", "  ", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"-", " ", 
           RowBox[{"table", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"\[Phi]osteric", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cosh", "[", 
               RowBox[{"table", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "-", "1"}], 
             ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "table", "]"}], "-", "90"}]}], "}"}]}], 
    "]"}]}], ";", 
  RowBox[{"tTB", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", " ", 
       RowBox[{"0.001", "cbo", " ", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{"table", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"\[Phi]osteric", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Cosh", "[", 
               RowBox[{"table", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "-", "1"}], 
             ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "62", ",", 
       RowBox[{"Length", "[", "table", "]"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"tCe", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", 
       RowBox[{"0.001", "cbCe", "  ", 
        RowBox[{"Exp", "[", 
         RowBox[{"4", " ", 
          RowBox[{"table", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "45", ",", 
       RowBox[{"Length", "[", "table", "]"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"tH", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", 
       RowBox[{"2", " ", "0.001", "cbw", " ", 
        RowBox[{"Exp", "[", " ", 
         RowBox[{"table", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "table", "]"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"tSO4", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", 
       RowBox[{"0.001", 
        RowBox[{"(", 
         RowBox[{"cbw", "+", 
          RowBox[{"2", "cbCe"}]}], ")"}], " ", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          RowBox[{"table", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "3"}], "]"}], "]"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "table", "]"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"tBA", ",", "tTB", ",", "tH", ",", "tSO4", ",", "tCe"}], "}"}], 
    ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".35"}], ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2.200"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", "Red", ",", "Black", ",", "Magenta", ",", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", ".6", ",", "0"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", ".8"}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", ".35"}], ",", "3000"}], "}"}]}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1.4", "]"}]}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<\!\(\*SuperscriptBox[\(Ce\), \(\(4\)\(+\)\)]\)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{".4", ",", ".75"}], "}"}], ",", 
         RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SuperscriptBox[\(H\), \(+\)]\)\>\"", ",", 
           RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{".28", ",", "1.25"}], "}"}], ",", 
         RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SuperscriptBox[\(BA\), \(+\)]\)\>\"", ",", 
           RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".21"}], ",", "2.0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\!\(\*SuperscriptBox[\(TB\), \(-\)]\)\>\"", ",", 
           RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{".25", ",", "2.0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SubsuperscriptBox[\(SO\), \(4\), \(\(2\)\(-\)\)]\)\>\"", 
           ",", 
           RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", ".25"}], ",", "1.25"}], "}"}], ",", 
         RowBox[{"Background", "\[Rule]", "White"}]}], "]"}]}], "}"}]}], ",", 
    
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \(w\)]\)\
\[Phi] (V)\>\"", ",", "16", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubscriptBox[StyleBox[\"c\",FontSlant->\"Italic\"], \
StyleBox[\"i\",FontSlant->\"Italic\"]]\)(0) (M)\>\"", ",", "16", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}]}], 
      "}"}]}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "250"}], "}"}]}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8677458427015*^9, 3.867745850017913*^9}, {
   3.8677461572572517`*^9, 3.867746283850274*^9}, {3.8677463348311634`*^9, 
   3.8677464027068825`*^9}, {3.8677464800362186`*^9, 3.867746502983859*^9}, {
   3.86774654922234*^9, 3.867746634913291*^9}, {3.867746676144163*^9, 
   3.8677466926333923`*^9}, 3.8677475690741315`*^9, {3.8677477388336296`*^9, 
   3.8677477626068716`*^9}, {3.8677479267659597`*^9, 
   3.8677479547056093`*^9}, {3.867747986592065*^9, 3.8677480112245083`*^9}, {
   3.867748086619441*^9, 3.8677480890062447`*^9}, {3.8677482226980796`*^9, 
   3.8677482782965775`*^9}, {3.867749131096073*^9, 3.8677493467040515`*^9}, {
   3.8677493785749073`*^9, 3.8677495079771347`*^9}, {3.8677516775665455`*^9, 
   3.867751726769032*^9}, {3.867759199746557*^9, 3.8677592186069903`*^9}, {
   3.86780728011969*^9, 3.8678073472778077`*^9}, {3.867807378696263*^9, 
   3.8678073928298874`*^9}, {3.8678074339203596`*^9, 
   3.8678074706584244`*^9}, {3.867807527083723*^9, 3.867807557612977*^9}, 
   3.867807594210641*^9, {3.8678076244902945`*^9, 3.8678076245526943`*^9}, {
   3.8678197711678953`*^9, 3.867819911646142*^9}, {3.867819947370205*^9, 
   3.867820038723965*^9}, {3.8678224718914385`*^9, 3.8678224719850388`*^9}, 
   3.8678226095304804`*^9, {3.8680094926289215`*^9, 3.8680095977107058`*^9}, 
   3.8680130732720103`*^9, {3.8680132002406335`*^9, 3.868013223937075*^9}, 
   3.868064708470003*^9, {3.8680648156577916`*^9, 3.8680649006767406`*^9}, {
   3.86806766489118*^9, 3.86806766518758*^9}, {3.8680677146396675`*^9, 
   3.8680677204116774`*^9}, {3.8680679330556507`*^9, 
   3.8680679332428513`*^9}, {3.8683272441822643`*^9, 
   3.8683272585498896`*^9}, {3.8683311830823827`*^9, 3.8683311831915827`*^9}, 
   3.868331286728965*^9, {3.924342503416492*^9, 3.9243425103703623`*^9}, {
   3.924342562361714*^9, 3.9243427486465197`*^9}, {3.924342791316224*^9, 
   3.9243427922979183`*^9}, {3.92434285368097*^9, 3.924343040653241*^9}, 
   3.9243431793466253`*^9, {3.924343262553083*^9, 3.924343288390256*^9}, {
   3.924343603862998*^9, 3.924343606563978*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"8daf8c7d-2241-487e-acd7-f28bf42249b4"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[0, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[LineBox[CompressedData["
1:eJw1lAtMk1cUxyuO0InBjRUnMgzEOdjc1DGWQSqcoQ5w2piSKQmPMHlsOMiE
jaJC2DImCSEgOKADFJRRhG08dOAAJ5w+EAoUaGkLPjoE5sCUIQ9p1QL91t5e
TvLl5st37+/8//9z83nGng5LsGOxWHzLY12/IDWKPwa+kGQ/ZcClKWQygzOK
4uZjV1iLDMgM3lGFUi06Cb5+bp5jICVg01hNihaL/kyajtczsCNnlt++Q4ve
xps9nGkGBhXW0uDJyJ6Y2QkGMjlWoAYrLrOmuu4zYKUZvDWYWB8hjlYzYIFZ
iGo0OQiiCvoZILgcNdY+eDebLWbgA1Jq/DkxtzmrhQGLOAtwBA8djfMqEDFg
pUUVjmCH8I/hnp8YIPICRtAreP5hXRYDBDerQlffklNl8QxUlFtLhUbB64rH
wQyEEqAKvRLv7R3eyQCxa1Bi3lTVvgSTGUTEsBLfs6tcqO0zQ5gVx1dihff4
RHKRGRhSw8h2CPpFwDNDNBE0jMKddhnRzBqQ7e1DeEau0V8TrQGJgzOEn6Rn
vybmrkEqETyIh6rDz2yWrYLCVlgqXpAu+a3COyQvBepTJPNPLq3QfAawKNBB
Va830Tz6kZsbUeT0pon670ddmXwhNeQFELvlfXgr1D3u2mfPqT85bi0Jf9v9
6DPqR44uRt6u1T1GIPKaerHN0fP33cwyENymXvQRKlbC8SnY7ksPth1O3fjo
myUg8UvvoO/nSxcV7ov0PtzBbi+3y6bceSDyMrpxg1ts5odj/9F5y7Dm3PRi
/l49+JD5yjBXZ7+rt2KGzlOKG2aeJUs9/qXzk6BHY6TBQz5F5yXBxvDx918V
TgDB1YjRcPLjoa/e+JvOA7GmccaJn3CP5t+FLo8q2R+xR2nenXi3kN/CfklN
872NZ7tPbG0+roSHRPAtzDU78VwWB6CM5NeBe65XvaIZ7KV5teOD+G2det9u
cCSG2tA3+siys6sExET+TTQ0BM9tvH8bzhH/rRjTkeTTFNJO/bZgtUq4TR3b
Sv3dwANd3KBlzg16366j276+T/2LG6CVtGvCkdq0/TO6OniL6G3Agy3G/OTp
GqrvV/zNzxgfWHyV6qnDlSLnIcfSS5BO+ovQm6u8UD4nhMekXzUm5pc3HHYs
pvwq7HA9MBxYWUh55ej2Q5Co3j8Pssj5EvTImPQTdOVAHdl/AXkDnrUR9tlw
mnw/j5tNE08CdFn0PQ118ceiEv86Cyxatv9AGojoWsATK2XLKZBnOw8XtUPp
487JILXxQa913r0l4Mv1/qCRf/et3/64dX3wvSQps3Mshu6vAvvzPi+fioyA
eZs/uOtvX+2lOk7Pi0A3aRYc3BK2ng9s/6e0+cQ0D67Y8oOQ7dyITHEo/A81
/7Sl
        "]],
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 0], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[LineBox[CompressedData["
1:eJw1VAtUVFUUZcSWH6BEwDRRQA1ByhRQVMTtJxVYTQaRkSIqIJ/UQEVUhKyE
llACrgkNlBECExVJBWP4DvJxDJA/DAMDAypOIyKQjvKd25v7nnetWW/tN++e
c/bed18Ln2D3fZN0dHS+Y37ap540PcRp+lUx/97LtIIuPsKMs7f2hGeIb8+p
5VfpueNfN9H86L40caPzYn/D2q+QyyA3kVC8all/TbnnDvyeRJf47JBo3vmW
3Yik+38TD6R6xQQ6+uIq/T5OPNS3MS1qbQCC6f9R4n2RKxclzjzA4VCxoaBb
KnoVAh1unWTfI4N7rnhq5OtZeByx7H58X3xn3WBHJMrY+jgwJJINTP7pbX+U
7Fxq/mtx9Nv5sKK687DSIZb7XogGE3XGvOR4DLD8MPmHwez0qQJufwY8a26F
OavOg9MHk4VPO+3jLuIyLXcNLpta/xw6m4qPveLL1FZZ+GXVpC07u9JRSOtn
Q7P64eza+qvIZHZL02/BL95i1xc/ZqGP9rsN04VxB2VTbmOlnXblQP+xZL9s
Wy5O0P65cFR/TcI/EqFCbcV0uIuEbMuAwJwivEvnyUOAhzByaKIU7iLaEGfs
XGbYvFeBS3S+fFw0M/y2PUkCRbi2YAFOLt5yjn+9GkvovEUwNd1vq29Zj1Dt
eCHFOOTXY5Jb0Qi2XAkkJc8EZndbwKNulOK04Whgw0gb0imfUhjwfdb4C+Rw
7tE2uAe5y+h00/Xd6Kf87sEkar2tvvcjaLsxLREQ63rTJPUJ7CnfckzzKxoO
4ykhowXLYfHe6voVESqwvlfgeqWPym3ac5hrx5lfib+P9Aj1016ALVeJJSrr
l5dTBhHgr133sevIxmNdyiHoU30kECYlD3jYvIS2mnG2BD1Lnm7Z7/cKX1KC
D+AaQfJ1EtSg5dQP0Dh8aW3UjddIpvr9A8EGpZx39w2glcepCke97pz48MYw
KN2eKlj33je3PzuCn6mh1Tg3x8lEs2MUtJxVDWbtdq2uNh7Dwxq6kJMVa+Fc
OIbDVO+H8A5MlgdtGwela1wLpcqT5904jnyqfy2ypwbZhW6egDcVsA7bg5Oq
DK5PcPmoh3em6EU8T8PxqUfM/NFCT74GGdSfeoy5FjjmxWnwmg5Uj4JeS3nv
fQ1cKIEGOE7y4E15o+H4NuBYmePWheYEz6l/DUCN3NB6EwEd16kRRkg06t9D
kEANaMSowO6UTTjBI6pHIxwEM67FxBNQe+2aYHT5ovJCGuH0acJy+e74plsE
1B5pEw76eQ9mFhNYU72asd01ZePRBwQRVJBmGHTNDTvTQDj9mjHX/hOFpYzA
jJ6HFlzw7SiMVRBQuiEt0B1wPdf7hKCcGtqCcslmn70qAhOqbyuueGSVWvQT
0OPi3wqr/MyiTwcJp3crggLTch//R7i8S7F3wniasZqAjuclxcz0k3nK1wR/
0fMkheboIsXBYcL50Yac0jrbnBHC5bENc9xivikbJbhCB2xDQto7GzLGCOdH
G7Jyonz3jBMuPzKsOa2jO8Fg9rqSodfJfuepibd+yJCY2lLdx+B11I92dKyz
Gd+sIVy+2vE+jzeSwODH1I92mF2Q8usYzOatA+mpeh/oEgIqX3QHHCISFyxl
MJu/DnQLn3W7MZi9H+ToTQmND2Ywm0c5Rvg69mcYXEf9kKNk8fHMSwxm89mJ
cJtlf9xk8CHqRyeij2nyChnM5rUTlUHuARIGz6J+dCHEIXR2A4PZ/HYh1nbG
AhmD2fuzCw6f2dQoGMzmWQGDlCT3XgbvooQVqBXpKVUMZvOtwKzlFXf6Gcze
V934vFm3bZDB/wOOp38r
        "]],
       FontFamily->"Arial",
       FontSize->14]}, 
     {GrayLevel[0], PointSize[0.0055000000000000005`], AbsoluteThickness[1.4], 
      StyleBox[LineBox[CompressedData["
1:eJw1VglUk2cWjbaKJe5HGFcKjnrcMKMCbsUL6HEpKsWlgjq4VRHHyiIuFUZR
1FKrLDNSigdBBUUEUevCUuRL2KEsgZCNQMJiwClgJUDYAhn4/+//zsnJycn/
v++9d9+991kd8d55bDSPx0se/ox8H2eOjBwXJX27UiCEWermhovTZGTNV8pw
Gw8hcrsXHgjLkZKYt9/5VIYK4WNvKo/3kZLDUwVOViIhLK63uqZbSIn3hMZp
9t1ClJWOnGoSu9+oxhIRAqaNBKwmDXYJiZuOijASrXthNdljaHnpc0+E4WDD
ESXEWRb7VKMUgQl3XULyL1so0qbnYCVzJKS9wMvZcl8OhpMbDlhFNJ9UUzbE
5mAk2oGwKtKyjn98uzYHTHr2VeTok9lqb0EumHCtleRE2fxIdWAu7kaPnEoy
79m5bZVludjCBKwkpb3pQcFz88CU2y0mJzZlfG8TkIcEpmAxyXc72b9AkYed
I+FcxeTGpK3XH6zJh5E5FWRCU+GP7XH5+CeTUAVJNf04Zi+/AMzj6eWEX8LP
XhJYAKYd08pJ6uib/ExdAXyZhMvIep88bxfvQpSyh2R16F/b6QqxmOlXKXkf
98XDNwFFtD9/kDHvOtaaji+m/SghsofScM/4Ylp/CeHt3yvQOZaAKTe6mDze
t9Qxq6WE1ldE4nKEd0R3/qD1FJEc9Zv0pi2lYNJLLSRnwqLONn9WBiacaSEJ
6fut81R+Gdh5KSBPBjvVPbfKwbQ/J59cTddWv3evoPOQTxoFUSlpZmIw6V3M
I3Mmv8pwDxJTvHNJ1waewa1NjBUMvrlEfNVr6RL3SopnDhn1t+c16wsqKX4i
8sxgf8S4ooriJSKjT56eqIytAhMuXkjiTHZb238hoXgQ8rIwRfLIV0L7n00k
DXyLaLmE9vsdGe96tjh5bTXtbxbpK+ZPDL5bDQ2TcCZZNbnzrVRfjV+Z/mWQ
iFmLrpxykdJ+pZP+80EyqwQp+ExBaSRb4T2qoUsKIZP+G/Jxk3l/gqMMPzD1
vybjyi3az92U0XpfkYXOjXdPVchofS/JYuncpMeT5XTeXpDmlVLDjh1yvGau
SyX7H7osjQqRYwGTbwpZ3HPQLI3IaX5JxDngdmxrp5zmk0g+P+2ceHa+AueY
+xPIo9WLFkbvVuADc98D4tw++WrMFQWNH0suOG7rL0xR0HjRRNRsd+iYTIF/
M+/fITr3OUoypEAi83woCYp+Vv73BUp4M/9fI27xAQb1Nu63P/lpy75ohzNK
8OhheadEAvs/dIMRJvZCJW6y78Mhf6VPUIsSOWx8TG2LPJw1qYa7H6sVKX3b
1tRw+aEr82jwf76roc/HYqynk6UuogZ/sfXh0vTQQJmIez8BUZ+O/fyiq4br
D+K0v23uXaxCHNs/2N6SnrU+poI1218czRQdUsSr8DvbfwQVJP18s0WFJyw+
WGZ7zkXzj1oOP5QJJrkHBtXCjsUXmetGD0yR13L4Y7aNt9N+2zrksfOBdpOo
rDkxdZjIzg/q6pcrFo5Xc/OFsBmOpbtvqBHDzh/MrLTtQXwNN5/wWX3yUESM
hptf8E54mdjNqYc/O9+Y63Xbr9+vnpt/vIAw4XNxPUYxaAhx+1ak7zubBo4/
+GXcBe21Bw0cv3D+Xumi5+aNaGf5h9yLibuu3Gnk+Ak3QYPTsllNsGH5ixD1
uizJ0yYoWX7Dwfer1vMb3lP9z4PAUXLORPselqw+oGJZ5o7dYVpOP3CoLHuH
mVMzPFl9wdnIqOJmQzPGs/qD0F5HozNp4fQJAev2+L8M+YBdrH7B4sDpKT5u
/+P0DUUHLbVi6z+p3g/rpI/Sbcq4VrCCVoKmmS0PPZtbOf3ExtQye5OiNtxg
9RUNyoeC+Snt1K9KodIn6gYiPlJ/K8XGJKua8gt/wY/Vb3itMv9eL/jE6Ts6
pqh2usd/Qgar/+iLzZu8ybwDHqw/YPXyt3cvhnRQfoixeWjc2Hd9HbQeMcbf
k/xL5aXj/Ae/dCRFJyt00LP+hHC/ufdMN3ViK+tfCLV5Y1v7spPzN/T9unaV
6ewutLH+B99Dz7TB17o4f0RYo5mrfWsXwln/xO4PkrfLvulGI+uv8M/ubt31
qpvzX8QnGaqSp+lpfyTICPZQr/LXc/6NmACH+wOVeixi/R0yq689DdY9CGT9
H1XzRn9wCOnh9gP0KNQd4voefMnuDzh6jS94s6qX2y9QNSBu19/q5fYPzJsQ
qour7+X2E/z3iK1r5oo+6kcy+Dd/u/2b4D7abxn8bCtwqqqP8l2O7i93XJlu
2Q8mvQNyKEwMbgdP9eM5M09y3J0V8/HrtH6KhwLLZ8RCyxugfFQg+cYj89Vb
B/CISVAByeE5Y7aHD1A8FJiaeMnDWjZA+aNEctCgTeNMA/VfJfofH9jr72Gg
eCjhdv+FS9t9A9YzeNRA6aQ9srPRQPlVA7vtmvDUuYNoYvCowUnHmZHjjgxS
vqlwyfRJi+f9QboPqLDncmC2pG6Q8k8Fs8e6ibtmDlF9qIV1ZWBY254hysda
SDzOZDwOH0IFg0ctbK16S34sGaL8rMPGfc1FkZ8ZqV/WQfd7UZBsnZHytQ53
bMQ3Xc4YYc7goYbMvdB57FMj5a8aEYuNeqPGSPVTDdftM4rum/IcWD5rwL/8
XN8yj+fA7ksaTPxzc618Pc+B5bcG234oT/dz4zmwelWP2Uva0zJ9eQ7/B8kb
kdQ=
        "]],
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[LineBox[CompressedData["
1:eJw1Vgs4lGkb7vDXoihFRUX1d2472a2tLHe7m1L99KN++a+UzalsoX67Hcia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        "]],
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[0, 0.6, 0], PointSize[0.0055000000000000005`], 
      AbsoluteThickness[1.4], 
      StyleBox[LineBox[CompressedData["
1:eJw1VQk0lWkYthSlMuVQTTNkmSuFSRvNlJ5QodWSUklcoc0WJWF0HBop0qIs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        "]],
       FontFamily->"Arial",
       FontSize->14]}}, {
     {RGBColor[0, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 0], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {GrayLevel[0], PointSize[0.0055000000000000005`], AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[0, 0.6, 0], PointSize[0.0055000000000000005`], 
      AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}}, {
     {RGBColor[0, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 0], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {GrayLevel[0], PointSize[0.0055000000000000005`], AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[0, 0.6, 0], PointSize[0.0055000000000000005`], 
      AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->
        14]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}, {
     {RGBColor[0, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 0], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {GrayLevel[0], PointSize[0.0055000000000000005`], AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[1, 0, 1], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, 
     {RGBColor[0, 0.6, 0], PointSize[0.0055000000000000005`], 
      AbsoluteThickness[1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->
        14]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}}}, {{}, {}}},
  AspectRatio->0.8,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-0.35, 3000.},
  BaseStyle->{FontSize -> 14, FontFamily -> "Arial", 
    AbsoluteThickness[1.4]},
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
     "\"\\!\\(\\*SuperscriptBox[\\(Ce\\), \\(\\(4\\)\\(+\\)\\)]\\)\"", 
      TraditionalForm], {0.4, 0.75}, Background -> GrayLevel[1]], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(H\\), \\(+\\)]\\)\"", SingleLetterItalics -> 
       False, StripOnInput -> False], TraditionalForm], {0.28, 1.25}, 
     Background -> GrayLevel[1]], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(BA\\), \\(+\\)]\\)\"", 
       SingleLetterItalics -> False, StripOnInput -> False], 
      TraditionalForm], {-0.21, 2.}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SuperscriptBox[\\(TB\\), \\(-\\)]\\)\"", 
       SingleLetterItalics -> False, StripOnInput -> False], 
      TraditionalForm], {0.25, 2.}], 
    InsetBox[
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubsuperscriptBox[\\(SO\\), \\(4\\), \
\\(\\(2\\)\\(-\\)\\)]\\)\"", SingleLetterItalics -> False, StripOnInput -> 
       False], TraditionalForm], {-0.25, 1.25}, Background -> GrayLevel[1]]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubscriptBox[StyleBox[\\\"c\\\",FontSlant->\\\"Italic\\\"], \
StyleBox[\\\"i\\\",FontSlant->\\\"Italic\\\"]]\\)(0) (M)\"", 16, 
       SingleLetterItalics -> False, StripOnInput -> False], TraditionalForm],
      None}, {
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \
\\(w\\)]\\)\[Phi] (V)\"", 16, SingleLetterItalics -> False, StripOnInput -> 
       False], TraditionalForm], None}},
  FrameStyle->{
    Directive[
     GrayLevel[0], 
     AbsoluteThickness[1]], 
    Directive[
     GrayLevel[0], 
     AbsoluteThickness[1]]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{Automatic, 250},
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-0.35, 0.5}, {0, 2.2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.924342625225103*^9, 3.924342749358287*^9, 3.924342792995569*^9, {
   3.924342887914603*^9, 3.924343040948887*^9}, 3.924343179898386*^9, {
   3.924343263366205*^9, 3.924343289151222*^9}, 3.924343608839636*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"95f5e546-2e26-4635-92e4-d8d3c1d53425"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Figure 6", "Subtitle",
 CellChangeTimes->{{3.924235368440298*^9, 
  3.924235375336377*^9}},ExpressionUUID->"bce8f218-79f5-4d76-a9de-\
d7b3da5d158e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "=", "96485"}], ";", 
  RowBox[{"R", "=", "8.3144"}], ";", 
  RowBox[{"T", "=", "298.15"}], ";", 
  RowBox[{"f", "=", 
   RowBox[{"F", "/", 
    RowBox[{"(", 
     RowBox[{"R", " ", "T"}], ")"}]}]}], ";", 
  RowBox[{
   RowBox[{"\[Zeta]", "[", "z_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "z", "]"}]}]}], ")"}], "^", "z"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sqrt", "[", "z", "]"}]}], ")"}]}]}], ";", 
  RowBox[{"panelA", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], " ", "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", "x"}], "}"}], "/.", 
        RowBox[{"z", "->", "1"}]}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", 
          RowBox[{"1", "-", "x"}]}], "}"}], "/.", 
        RowBox[{"z", "\[Rule]", "1"}]}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], " ", "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", "x"}], "}"}], "/.", 
        RowBox[{"z", "\[Rule]", "2"}]}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", 
          RowBox[{"1", "-", "x"}]}], "}"}], "/.", 
        RowBox[{"z", "\[Rule]", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.00001", ",", ".999999"}], "}"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", ".3"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1.4", "]"}]}], "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"\
], StyleBox[\"w\",FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".07"}], "\[IndentingNewLine]", ",", ".83"}], 
           "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"\
], StyleBox[\"o\",FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".07", "\[IndentingNewLine]", ",", ".83"}], "}"}]}], "]"}],
         ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<-\!\(\*StyleBox[\"z\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)= -2 \>\"", ",", 
          RowBox[{"{", 
           RowBox[{".015", "\[IndentingNewLine]", ",", ".12"}], "}"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<(a)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".125"}], ",", ".85"}], "}"}]}], "]"}], ",", "Blue", 
        ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<-\!\(\*StyleBox[\"z\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)= -1\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".06", ",", ".24"}], "}"}]}], "]"}], 
        RowBox[{"(*", 
         RowBox[{",", "Red", ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", ".58579"}], "}"}], "]"}]}], "*)"}], ",", 
        RowBox[{"FontSize", "\[Rule]", "9"}], ",", "Black", ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<aqueous anions\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".1"}], ",", ".55"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<compensate \!\(\*SuperscriptBox[\(EDOT\), \
\(\(\[Bullet]\)\(+\)\)]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".1"}], ",", ".45"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"\"\<organic anions\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".1", ",", ".55"}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<compensate \!\(\*SuperscriptBox[\(EDOT\), \
\(\(\[Bullet]\)\(+\)\)]\)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".1", ",", ".45"}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<(\!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \(w\)]\)\
\[Phi] - \!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \
\(w\)]\)\!\(\*SubscriptBox[\(\[Phi]\), \(p\)]\)) / V\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "16"}], 
         "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*StyleBox[SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"\
], StyleBox[RowBox[{\"o\", \" \"}],FontSlant->\"Plain\"]],FontSlant->\"Italic\
\"]\)\!\(\*StyleBox[\" \",FontSlant->\"Italic\"]\), \
\!\(\*StyleBox[SubscriptBox[StyleBox[\"x\",FontSlant->\"Italic\"], \
StyleBox[\"w\",FontSlant->\"Plain\"]],FontSlant->\"Italic\"]\)\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "16"}], 
         "]"}]}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".2", ",", ".4", ",", ".6", ",", ".8", ",", "1", ",", 
            RowBox[{"{", 
             RowBox[{".05", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".1", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".15", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".25", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".3", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".35", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".45", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".5", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".55", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".65", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".7", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".75", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".85", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".9", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{".95", ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".006", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
          "Automatic"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}]}], "}"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"400", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Blue", ",", "Black", ",", "Black"}], "}"}]}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".14"}], ",", ".14"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"56", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "6"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"panelB", "=", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], " ", "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", 
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}], 
            RowBox[{"x", "+", "z", "-", 
             RowBox[{"x", " ", "z"}]}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SqrtBox["z"]}], ")"}], "2"]}]}], "}"}], "/.", 
        RowBox[{"z", "->", "1"}]}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{
             RowBox[{"\[Zeta]", "[", "z", "]"}], " ", 
             RowBox[{
              RowBox[{"x", "^", "z"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"z", " ", "f"}], ")"}]}], ",", 
          RowBox[{
           FractionBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}], 
            RowBox[{"x", "+", "z", "-", 
             RowBox[{"x", " ", "z"}]}]], "8"}]}], "}"}], "/.", 
        RowBox[{"z", "\[Rule]", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.00001", ",", ".999999"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".3"}], ",", "0"}], "}"}]}], ",", 
     RowBox[{"BaseStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
        RowBox[{"AbsoluteThickness", "[", "1.4", "]"}]}], "}"}]}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{"\"\<(b)\>\"", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", ".125"}], ",", 
            RowBox[{"-", "1.25"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<-\!\(\*StyleBox[\"z\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)= -2\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".015", ",", 
            RowBox[{"-", ".45"}]}], "}"}], ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", "Blue", 
        ",", 
        RowBox[{"Text", "[", 
         RowBox[{
         "\"\<-\!\(\*StyleBox[\"z\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)= -1\>\"", ",", 
          RowBox[{"{", 
           RowBox[{".06", ",", 
            RowBox[{"-", ".6"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<(\!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \(w\)]\)\
\[Phi] - \!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \
\(w\)]\)\!\(\*SubscriptBox[\(\[Phi]\), \(p\)]\)) / V\>\"", ",", "16", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
         "\"\<\!\(\*StyleBox[\"j\",FontSlant->\"Italic\"]\)\!\(\*StyleBox[\" \
\",FontSlant->\"Italic\"]\)/ \
|\!\(\*SubscriptBox[StyleBox[\"j\",FontSlant->\"Italic\"], \"p1\"]\)|\>\"", 
          ",", "16", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".025"}], ",", "\"\<0.0\>\""}], "}"}], ",", 
            RowBox[{"-", ".2"}], ",", 
            RowBox[{"-", ".4"}], ",", 
            RowBox[{"-", ".6"}], ",", 
            RowBox[{"-", ".8"}], ",", 
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", "1.2"}], ",", 
            RowBox[{"-", "1.4"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".05"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".1"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".15"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".25"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".3"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".35"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".45"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".55"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".65"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".7"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".75"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".85"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".9"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".95"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.05"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.1"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.15"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.25"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.3"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.35"}], ",", "\"\<\>\"", ",", 
              RowBox[{"{", 
               RowBox[{".008", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
          "Automatic"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}]}], "}"}]}], 
     ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"400", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"56", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"45", ",", "3"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", "Black"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".14"}], ",", ".14"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.4"}], ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "panelA", "}"}], ",", 
     RowBox[{"{", "panelB", "}"}]}], "}"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", ".18"}]}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.924247823268194*^9, 3.924247832457992*^9}, {
  3.92424787160196*^9, 3.924248291437978*^9}, {3.924248321633359*^9, 
  3.924248429590108*^9}, {3.9242484964603443`*^9, 3.9242485510113297`*^9}, {
  3.92424859174957*^9, 3.924248705718052*^9}, {3.924248736214841*^9, 
  3.924248844130639*^9}, {3.9242489011835213`*^9, 3.92424891548495*^9}, {
  3.924249098133231*^9, 3.924249143412107*^9}, {3.924249203167438*^9, 
  3.924249321850898*^9}, {3.924249455957384*^9, 3.92424952532828*^9}, {
  3.924249584522377*^9, 3.924249621836566*^9}, {3.924249669636634*^9, 
  3.9242496716376038`*^9}, {3.924250145957633*^9, 3.92425022427577*^9}, {
  3.924253535320367*^9, 3.924253543770183*^9}, {3.924335162118494*^9, 
  3.92433516727999*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"073c57a4-23b2-4e2d-ad5e-39c90b95e7fc"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
          Opacity[0.3]], LineBox[CompressedData["
1:eJwVVnk41Pv/tRfiVhRFuRUqlaQU6jrqkhZCWZI10qVSNylFKkuIyH4jSpFl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           "]]},
         Annotation[#, "Charting`Private`Tag$13283#1"]& ], 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
          Opacity[0.3]], LineBox[CompressedData["
1:eJwV1Xk81Nv/B/CxtCAqlSVrqYiKdlReWrna5GupCJcSbSK0l2VClhJXN1tX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           "]]},
         Annotation[#, "Charting`Private`Tag$13283#2"]& ], 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
          0.3]], LineBox[CompressedData["
1:eJwVVWdczf0DLZSRSDKL0EBIg5TRSU8hlYyGFJpEKlKinoYrhJYGSlq3brs7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           "]]},
         Annotation[#, "Charting`Private`Tag$13283#3"]& ], 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
          0.3]], LineBox[CompressedData["
1:eJwV1Hk41OsXAPBpoboSSYusRRGVpZu0cEYbUpJrjVtkyVKWLCWlMU1J1khl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           "]]},
         Annotation[#, "Charting`Private`Tag$13283#4"]& ]}, {}},
      AspectRatio->0.3,
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      BaseStyle->{FontSize -> 14, FontFamily -> "Arial", 
        AbsoluteThickness[1.4]},
      DisplayFunction->Identity,
      Epilog->{
        InsetBox[
         FormBox[
         "\"\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"\
Italic\\\"], \
StyleBox[\\\"w\\\",FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\"\
", TraditionalForm], {-0.07, 0.83}], 
        InsetBox[
         FormBox[
         "\"\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"\
Italic\\\"], \
StyleBox[\\\"o\\\",FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\"\
", TraditionalForm], {0.07, 0.83}], 
        InsetBox[
         FormBox[
         "\"-\\!\\(\\*StyleBox[\\\"z\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)= -2 \"", TraditionalForm], {
         0.015, 0.12}, Background -> GrayLevel[1]], 
        InsetBox[
         FormBox["\"(a)\"", TraditionalForm], {-0.125, 0.85}], 
        RGBColor[0, 0, 1], 
        InsetBox[
         FormBox[
         "\"-\\!\\(\\*StyleBox[\\\"z\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)= -1\"", TraditionalForm], {
         0.06, 0.24}], FontSize -> 9, 
        GrayLevel[0], 
        InsetBox[
         FormBox["\"aqueous anions\"", TraditionalForm], {-0.1, 0.55}], 
        InsetBox[
         FormBox[
         "\"compensate \\!\\(\\*SuperscriptBox[\\(EDOT\\), \\(\\(\[Bullet]\\)\
\\(+\\)\\)]\\)\"", TraditionalForm], {-0.1, 0.45}], 
        InsetBox[
         FormBox["\"organic anions\"", TraditionalForm], {0.1, 0.55}], 
        InsetBox[
         FormBox[
         "\"compensate \\!\\(\\*SuperscriptBox[\\(EDOT\\), \\(\\(\[Bullet]\\)\
\\(+\\)\\)]\\)\"", TraditionalForm], {0.1, 0.45}]},
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox[
          StyleBox[
          "\"\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"\
Italic\\\"], StyleBox[RowBox[{\\\"o\\\", \\\" \
\\\"}],FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\
StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\), \
\\!\\(\\*StyleBox[SubscriptBox[StyleBox[\\\"x\\\",FontSlant->\\\"Italic\\\"], \
StyleBox[\\\"w\\\",FontSlant->\\\"Plain\\\"]],FontSlant->\\\"Italic\\\"]\\)\"\
", SingleLetterItalics -> False, 16, StripOnInput -> False], TraditionalForm],
          None}, {
         FormBox[
          StyleBox[
          "\"(\\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \\(w\
\\)]\\)\[Phi] - \\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \
\\(w\\)]\\)\\!\\(\\*SubscriptBox[\\(\[Phi]\\), \\(p\\)]\\)) / V\"", 
           SingleLetterItalics -> False, 16, StripOnInput -> False], 
          TraditionalForm], None}},
      FrameStyle->{
        Directive[
         GrayLevel[0], 
         AbsoluteThickness[1]], 
        Directive[
         GrayLevel[0], 
         AbsoluteThickness[1]]},
      FrameTicks->{{{{0.2, 
           FormBox["0.2`", TraditionalForm]}, {0.4, 
           FormBox["0.4`", TraditionalForm]}, {0.6, 
           FormBox["0.6`", TraditionalForm]}, {0.8, 
           FormBox["0.8`", TraditionalForm]}, {1, 
           FormBox["1", TraditionalForm]}, {0.05, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.1, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.15, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.25, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.3, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.35, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.45, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.5, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.55, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.65, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.7, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.75, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.85, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.9, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}, {0.95, 
           FormBox["\"\"", TraditionalForm], {0.006, 0}}}, Automatic}, {
        Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{56, 1}, {0, 6}},
      ImageSize->{400, Automatic},
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None},
      PlotRange->{{-0.14, 0.14}, {0, 1}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]},
    {
     GraphicsBox[{{{}, {}, 
        TagBox[
         {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], FaceForm[
          Opacity[0.3]], LineBox[CompressedData["
1:eJwV1mc4l18fAHA7GSkjNAiREVJkFEeRETIyIisjVPaeZZMUUXYRZWbv9bW3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           "]]},
         Annotation[#, "Charting`Private`Tag$13322#1"]& ], 
        TagBox[
         {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], FaceForm[Opacity[
          0.3]], LineBox[CompressedData["
1:eJwV13c4Vv8bB3DaQ2U07AoJkRAh+iCSkOxV9sgmmxAZCZGZyPaYGY89ctsy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           "]]},
         Annotation[#, "Charting`Private`Tag$13322#2"]& ]}, {}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      BaseStyle->{FontSize -> 14, FontFamily -> "Arial", 
        AbsoluteThickness[1.4]},
      DisplayFunction->Identity,
      Epilog->{
        InsetBox[
         FormBox["\"(b)\"", TraditionalForm], {-0.125, -1.25}], 
        InsetBox[
         FormBox[
         "\"-\\!\\(\\*StyleBox[\\\"z\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)= -2\"", TraditionalForm], {
         0.015, -0.45}, Background -> GrayLevel[1]], 
        RGBColor[0, 0, 1], 
        InsetBox[
         FormBox[
         "\"-\\!\\(\\*StyleBox[\\\"z\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)= -1\"", TraditionalForm], {
         0.06, -0.6}]},
      Frame->{{True, True}, {True, True}},
      FrameLabel->{{
         FormBox[
          StyleBox[
          "\"\\!\\(\\*StyleBox[\\\"j\\\",FontSlant->\\\"Italic\\\"]\\)\\!\\(\\\
*StyleBox[\\\" \\\",FontSlant->\\\"Italic\\\"]\\)/ \
|\\!\\(\\*SubscriptBox[StyleBox[\\\"j\\\",FontSlant->\\\"Italic\\\"], \
\\\"p1\\\"]\\)|\"", 16, SingleLetterItalics -> False, StripOnInput -> False], 
          TraditionalForm], None}, {
         FormBox[
          StyleBox[
          "\"(\\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \\(w\
\\)]\\)\[Phi] - \\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \
\\(w\\)]\\)\\!\\(\\*SubscriptBox[\\(\[Phi]\\), \\(p\\)]\\)) / V\"", 16, 
           SingleLetterItalics -> False, StripOnInput -> False], 
          TraditionalForm], None}},
      FrameStyle->{
        Directive[
         GrayLevel[0], 
         AbsoluteThickness[1]], 
        Directive[
         GrayLevel[0], 
         AbsoluteThickness[1]]},
      FrameTicks->{{{{-0.025, 
           FormBox["\"0.0\"", TraditionalForm]}, {-0.2, 
           FormBox[
            RowBox[{"-", "0.2`"}], TraditionalForm]}, {-0.4, 
           FormBox[
            RowBox[{"-", "0.4`"}], TraditionalForm]}, {-0.6, 
           FormBox[
            RowBox[{"-", "0.6`"}], TraditionalForm]}, {-0.8, 
           FormBox[
            RowBox[{"-", "0.8`"}], TraditionalForm]}, {-1, 
           FormBox[
            RowBox[{"-", "1"}], TraditionalForm]}, {-1.2, 
           FormBox[
            RowBox[{"-", "1.2`"}], TraditionalForm]}, {-1.4, 
           FormBox[
            RowBox[{"-", "1.4`"}], TraditionalForm]}, {-0.05, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.1, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.15, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.25, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.3, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.35, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.45, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.5, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.55, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.65, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.7, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.75, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.85, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.9, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-0.95, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.05, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.1, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.15, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.25, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.3, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}, {-1.35, 
           FormBox["\"\"", TraditionalForm], {0.008, 0}}}, Automatic}, {
        Automatic, Automatic}},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      ImagePadding->{{56, 1}, {45, 3}},
      ImageSize->{400, Automatic},
      Method->{
       "DefaultGraphicsInteraction" -> {
         "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
          "Effects" -> {
           "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
            "Droplines" -> {
             "freeformCursorMode" -> True, 
              "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
        "ScalingFunctions" -> None},
      PlotRange->{{-0.14, 0.14}, {-1.4, 0}},
      PlotRangeClipping->True,
      PlotRangePadding->{{0, 0}, {0, 0}},
      Ticks->{Automatic, Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{-0.18}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.924247874855926*^9, {3.9242479053792543`*^9, 3.924247922112162*^9}, {
   3.924247960984083*^9, 3.924248127794565*^9}, {3.9242481648895884`*^9, 
   3.924248178470879*^9}, {3.924248210480798*^9, 3.924248226211472*^9}, 
   3.924248260617008*^9, 3.924248294157793*^9, 3.924248347232793*^9, {
   3.9242483861862373`*^9, 3.924248430140373*^9}, {3.924248524948889*^9, 
   3.9242485517929707`*^9}, {3.924248598553544*^9, 3.9242487597295647`*^9}, {
   3.924248793418193*^9, 3.924248845109406*^9}, 3.92424891664174*^9, {
   3.924249100638441*^9, 3.924249143740766*^9}, 3.924249241922896*^9, {
   3.924249289222921*^9, 3.924249322462195*^9}, {3.9242494567183037`*^9, 
   3.924249525647973*^9}, {3.92424960097589*^9, 3.9242496221668863`*^9}, {
   3.924249672430768*^9, 3.924249684977827*^9}, {3.924250165964712*^9, 
   3.9242502246228437`*^9}, 3.924253544653172*^9, 3.924335105111721*^9, 
   3.924335168492291*^9, 3.9243436155715427`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"ca0ec1db-cd41-483c-b622-f4383cd14ce5"]
}, Open  ]],

Cell[BoxData[Cell["Figure 7c", "Subtitle",
  CellChangeTimes->{{3.924235368440298*^9, 3.924235375336377*^9}},
  ExpressionUUID->"a696a86a-fd38-4d6a-b9a0-b39b08be9cf2"]], "Input",
 CellChangeTimes->{{3.924244297224786*^9, 3.924244298193664*^9}, {
  3.924335144428566*^9, 3.924335149025803*^9}, {3.92434153265816*^9, 
  3.924341532658181*^9}},ExpressionUUID->"b9ca24ea-842b-4af4-b3c5-\
cc8f605342e4"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cbo", "=", "5"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"cbw", "=", "200"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"cEDOT", "=", "10"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"csite", "=", "362"}], 
  RowBox[{"(*", "mM", "*)"}], ";", 
  RowBox[{"kads", "=", "100"}], 
  RowBox[{"(*", 
   RowBox[{"1", "/", "mM"}], "*)"}], ";", 
  RowBox[{"d", "=", 
   RowBox[{"400", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "9"}]}]}]}], " ", 
  RowBox[{"(*", "m", "*)"}], ";", 
  RowBox[{"F", "=", "96485"}], 
  RowBox[{"(*", 
   RowBox[{"C", "/", "mol"}], "*)"}], ";", 
  RowBox[{"R", "=", "8.3144"}], 
  RowBox[{"(*", 
   RowBox[{"J", "/", 
    RowBox[{"(", 
     RowBox[{"K", " ", "mol"}], ")"}]}], "*)"}], ";", 
  RowBox[{"T", "=", "298.15"}], 
  RowBox[{"(*", "K", "*)"}], ";", 
  RowBox[{"f", "=", 
   RowBox[{"F", "/", 
    RowBox[{"(", 
     RowBox[{"R", " ", "T"}], ")"}]}]}], ";", 
  RowBox[{"KTB", "=", ".3"}], ";", 
  RowBox[{"KH", "=", 
   RowBox[{"3", " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "8"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  StyleBox[
   RowBox[{"\[Nu]", "=", ".001"}],
   FontColor->GrayLevel[0]], 
  StyleBox[" ",
   FontColor->GrayLevel[0]], 
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"scan", " ", "rate", " ", 
     RowBox[{"V", "/", "s"}]}], "*)"}],
   FontColor->GrayLevel[0]], ";", 
  RowBox[{"table", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[CapitalDelta]", ",", "x"}], "}"}], "/.", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"cEDOT", "+", 
          RowBox[{"csite", "/", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"1", "/", 
              RowBox[{"(", 
               RowBox[{"kads", " ", "KH", " ", "2", " ", "cbw", " ", 
                RowBox[{"Exp", "[", 
                 RowBox[{"-", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}], 
               ")"}]}]}], ")"}]}], "+", 
          RowBox[{"KH", " ", "2", " ", "cbw", " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"x", "-", "\[CapitalDelta]"}], ")"}]}], "]"}]}]}], 
         "\[Equal]", 
         RowBox[{"KTB", " ", "cbo", " ", 
          RowBox[{"Exp", "[", "x", "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{".5", "\[CapitalDelta]"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[CapitalDelta]", ",", "0", ",", 
       RowBox[{".5", "f"}], ",", 
       RowBox[{".005", "f"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tco", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"table", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1"}], "]"}], "]"}], "/", "f"}], ",", 
       RowBox[{"KTB", " ", "cbo", " ", 
        RowBox[{"Exp", "[", 
         RowBox[{"table", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{"Length", "[", "table", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tCo", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{".5", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"tco", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", 
          RowBox[{"tco", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ")"}]}], 
       ",", 
       RowBox[{"F", " ", "d", " ", 
        RowBox[{"10", "^", "2"}], 
        RowBox[{"(*", 
         RowBox[{"\[Mu]F", " ", 
          RowBox[{"cm", "^", 
           RowBox[{"-", "2"}]}]}], "*)"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}], "-", 
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}], "-", 
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "table", "]"}], "-", "1"}]}], "}"}]}], "]"}]}],
   ";", 
  RowBox[{"tj", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{".5", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"tco", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "+", 
          RowBox[{"tco", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}]}], ")"}]}], 
       ",", 
       RowBox[{"\[Nu]", " ", "F", " ", "d", " ", 
        RowBox[{"10", "^", "2"}], 
        RowBox[{"(*", 
         RowBox[{"\[Mu]A", " ", 
          RowBox[{"cm", "^", 
           RowBox[{"-", "2"}]}]}], "*)"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "2"}], "]"}], "]"}], "-", 
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"i", "+", "1"}], ",", "1"}], "]"}], "]"}], "-", 
           RowBox[{"tco", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}]}], ")"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", 
       RowBox[{
        RowBox[{"Length", "[", "table", "]"}], "-", "1"}]}], "}"}]}], "]"}]}],
   ";", 
  RowBox[{"ListPlot", "[", 
   RowBox[{"tj", ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", ".75"}], ",", 
    RowBox[{"BaseStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontSize", "\[Rule]", "14"}], ",", 
       RowBox[{"FontFamily", "\[Rule]", "\"\<Arial\>\""}], ",", 
       RowBox[{"AbsoluteThickness", "[", "1.4", "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<1 mV/s\>\"", ",", 
          RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{".3", ",", "1"}], "}"}]}], "]"}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameLabel", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SubsuperscriptBox[\(\[CapitalDelta]\), \(o\), \(w\)]\)\
\[Phi] (V)\>\"", ",", "16", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*StyleBox[\"j\",FontSlant->\"Italic\"]\) (\[Micro]A \
\!\(\*SuperscriptBox[\(cm\), \(-2\)]\))\>\"", ",", 
         RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", "16"}], 
        "]"}]}], "}"}]}], ",", 
    RowBox[{"FrameStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Black", ",", 
         RowBox[{"AbsoluteThickness", "[", "1", "]"}]}], "]"}]}], "}"}]}], 
    ",", 
    RowBox[{"ImageSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "250"}], "}"}]}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{".1", ",", ".5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "13"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.8691185437404313`*^9, 3.8691185451600337`*^9}, {
   3.869118635265792*^9, 3.869118636482594*^9}, {3.869118795181673*^9, 
   3.8691188381129484`*^9}, {3.8691188983914537`*^9, 3.869118929513509*^9}, {
   3.8691198589163413`*^9, 3.869119907479226*^9}, {3.869119962484923*^9, 
   3.869120014323814*^9}, {3.869120046725071*^9, 3.8691200601098948`*^9}, {
   3.8691201120579853`*^9, 3.869120127112012*^9}, {3.9243408386173363`*^9, 
   3.924340993218019*^9}, 3.924341059135262*^9, {3.924341095353106*^9, 
   3.924341231871666*^9}, {3.9243412727774973`*^9, 3.924341319859939*^9}, {
   3.924341355808251*^9, 3.924341504616679*^9}, {3.924341685557046*^9, 
   3.92434168913412*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"d5146e24-ab22-4055-9fea-420f60ed453a"],

Cell[BoxData[
 GraphicsBox[{{}, {{{}, {}, 
     {RGBColor[1, 0, 0], PointSize[0.009166666666666668], AbsoluteThickness[
      1.4], 
      StyleBox[LineBox[CompressedData["
1:eJwtlHtQU0cYxSNFoFQjUlAwFiG0SqlaI4ijKGcto1ir04DaKSPa+kK0I8ZR
KSLKOC0iPoqR1kClFQUcChoKFIyiBUMUJDwCCYaQCJKAVtQaeYhYJOXeuztz
5/6R3N2z53e+47NlT8R2Ox6Pt23sYd6H3ORhXQnb4Fls1PGbkqHwSn4arjiC
9vT5nZk7T+DXTGalwqYT9ZUOpeFZOPMPKdrmH0woXJcOZ32OZKmzDIeGvwjd
t0GGj6PSlIN+Wfj3etyc6aIs5I79qs/Jxgze2gjL22wEsCsH+iBVb8a+XFQP
+o19kYfyvSs/O3o2HxGsgHwIlT9ad8VdhTmBEViAF1Mmx75zoRh7me0kVxEg
LIoJH18GHrv+RKW/xxODTYGVXcwHxXCPrNV6XLwFRk1UWgmSVh2V9h++DVau
vhSy8zN/SpGqMIO5rlcZ/gtatHy/Wy12RDOrHGlbdhSkTKoH446b/BpCnsck
SZdr8IqRO6jAObsE99yaFoSwBtzAgV7XWLO0FceY7ZIrcHj8XnNwfhsa65l1
E59vsrdo+Sawdrv9DUPyfjdRXSdYu6IqEVwuQ9mLLnr/Kkx1zAma5d9Nz6tC
rlTiUyV7RHncxpvzN+esWPKEnq9ERYjSb1jwjPqlRLkxZ3d68Auw10uuRszJ
GZd9xS8pHxV8l4grTLP6wcqrV2Go12XzyKxBsLgkdyCa6/zb9bVDVO9d/LDQ
5LFfPkzzcReqBZKowuARqr8Gxjjbvf7RUcpjzEd96I6BtzzC8a/F4LGNTRPP
2xGOzz3w++Y9PPK1PeHydA+hj7cutyx0IGdYXnX4JD57wx+LnQiXFzUcUi6l
jG52Jm0sPzX4dU0Xr8knkERWYD0E0Ul2C3wmEY5nA3adw6Nskwtht1M2YNXS
L6cNLXYlLN7oRvAGpm0qKXifcPltglpwZd1Gf3fC8W5CQF/Qso5rUwjnlwbl
Gr5tg9iDcPOigWfhwQ6h1ZM0sP5pYG7I9j15VkDPb8bptGUZFtEHhMtrM85e
Fki21nhRPc0IqP+9Mf0jb8L524L0Ow7Eu92b6muBPs9esSvRh3B+tyDxsFor
chRSvVq81gfk8Q8ICee/Fideqc+UVQmpfi0cP83sC+sREo6HDr47S2aXdggJ
ly8ddFMti6YUCCkfHWKHnNx9VwgJlzcdNH6zP4wt9aG8WmGIv/xz1oA34fLX
itCr9jHb+N6UXyuSpicMX+F7ES6P9xG4Plb8uFFAed7HHMdI8bw9noTL5310
7xN1Xxo3lQSyfPWw3QnX7Za5ES6veqz9/ujx63Al3LzqcSrxjcTi4EJ5tOGp
oyBk8bP3KI82hGt7T2lnOlEebfC3Rs5tqLanPAwY52MbOaYaR3kYsCnP2BO2
ZpT2jwGB8vXvRtQNw501sB2zRzPX8foHaR+046XnhPhsRR/NfzsyrL7RqyZY
af8Z4fKXp1pe+ZTOgxEnViht09b8Q/vDiOZLAYHehT10PkzYsixOurrWQufd
hFQnrbVOZqZ9aYL1RkVRxmQznX8TGidmbZfPN9N+e4BvfnE3+L010z54ANeq
50GH4rtpPz8AP5FXXVT8iPZDB8S7v1UrKp6A49GB1CNrVmuKnoPdrqsDF5pv
Zlq/egmORydunZ5cEh87QPusE2Hih6rKBa9pf3biu8hFpq6aEfwPd9H+Xg==

        "]],
       FontFamily->"Arial",
       FontSize->14]}}, 
    {RGBColor[1, 0, 0], PointSize[0.009166666666666668], AbsoluteThickness[
     1.4], 
     StyleBox[{},
      FontFamily->"Arial",
      FontSize->14]}, {
     {RGBColor[1, 0, 0], PointSize[0.009166666666666668], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, {}}, {
     {RGBColor[1, 0, 0], PointSize[0.009166666666666668], AbsoluteThickness[
      1.4], 
      StyleBox[{},
       FontFamily->"Arial",
       FontSize->14]}, {}}}, {{}, {}}},
  AspectRatio->0.75,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  BaseStyle->{FontSize -> 14, FontFamily -> "Arial", 
    AbsoluteThickness[1.4]},
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
      StyleBox[
      "\"1 mV/s\"", SingleLetterItalics -> False, StripOnInput -> False], 
      TraditionalForm], {0.3, 1}]},
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      StyleBox[
      "\"\\!\\(\\*StyleBox[\\\"j\\\",FontSlant->\\\"Italic\\\"]\\) (\[Micro]A \
\\!\\(\\*SuperscriptBox[\\(cm\\), \\(-2\\)]\\))\"", SingleLetterItalics -> 
       False, 16, StripOnInput -> False], TraditionalForm], None}, {
     FormBox[
      StyleBox[
      "\"\\!\\(\\*SubsuperscriptBox[\\(\[CapitalDelta]\\), \\(o\\), \
\\(w\\)]\\)\[Phi] (V)\"", 16, SingleLetterItalics -> False, StripOnInput -> 
       False], TraditionalForm], None}},
  FrameStyle->{
    Directive[
     GrayLevel[0], 
     AbsoluteThickness[1]], 
    Directive[
     GrayLevel[0], 
     AbsoluteThickness[1]]},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{Automatic, 250},
  Method->{
   "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.1, 0.5}, {0, 13}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.924335181846946*^9, {3.924340851237607*^9, 3.9243408607624903`*^9}, 
   3.9243409053533907`*^9, 3.9243410154146433`*^9, 3.9243410726618*^9, 
   3.924341113071813*^9, {3.924341154398608*^9, 3.924341232053809*^9}, 
   3.92434128030404*^9, {3.924341320578475*^9, 3.924341505051881*^9}, {
   3.924341686405229*^9, 3.9243416900376377`*^9}, 3.924343619058605*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"7be780ad-467e-40b2-89e8-f3d30f93125d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1216, 1067},
WindowMargins->{{250, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.0 para Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 386, 6, 53, "Subtitle",ExpressionUUID->"4fdab687-5f4e-4b59-a56e-7c66aee03390"],
Cell[CellGroupData[{
Cell[991, 32, 15088, 402, 755, "Input",ExpressionUUID->"8daf8c7d-2241-487e-acd7-f28bf42249b4"],
Cell[16082, 436, 17488, 369, 267, "Output",ExpressionUUID->"95f5e546-2e26-4635-92e4-d8d3c1d53425"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33619, 811, 154, 3, 53, "Subtitle",ExpressionUUID->"bce8f218-79f5-4d76-a9de-d7b3da5d158e"],
Cell[CellGroupData[{
Cell[33798, 818, 22288, 577, 777, "Input",ExpressionUUID->"073c57a4-23b2-4e2d-ad5e-39c90b95e7fc"],
Cell[56089, 1397, 47028, 839, 387, "Output",ExpressionUUID->"ca0ec1db-cd41-483c-b622-f4383cd14ce5"]
}, Open  ]],
Cell[103132, 2239, 398, 6, 46, "Input",ExpressionUUID->"b9ca24ea-842b-4af4-b3c5-cc8f605342e4"],
Cell[CellGroupData[{
Cell[103555, 2249, 9291, 266, 541, "Input",ExpressionUUID->"d5146e24-ab22-4055-9fea-420f60ed453a"],
Cell[112849, 2517, 4612, 110, 302, "Output",ExpressionUUID->"7be780ad-467e-40b2-89e8-f3d30f93125d"]
}, Open  ]]
}, Open  ]]
}
]
*)

